/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.Mailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageNameMailbox;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class MailboxBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    private static final MapCodec<MailboxBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_4719.field_46535.fieldOf("wood_type").forGetter(block -> block.type), (App)MailboxBlock.method_54096()).apply((Applicative)builder, MailboxBlock::new));
    private final class_4719 type;

    public MailboxBlock(class_4719 type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)DIRECTION, (Comparable)class_2350.field_11043)).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public class_4719 getWoodType() {
        return this.type;
    }

    protected MapCodec<MailboxBlock> method_53969() {
        return CODEC;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 standShape = class_2248.method_9541((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)11.0, (double)9.5);
        class_265 boxShape = class_2248.method_9541((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
        class_265 joinedShape = class_259.method_1082((class_265)standShape, (class_265)boxShape, (class_247)class_247.field_1366).method_1097();
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> joinedShape)));
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof MailboxBlockEntity) {
                MailboxBlockEntity mailbox = (MailboxBlockEntity)class_25862;
                mailbox.getMailbox().owner().setValue((Object)player.method_5667());
                DeliveryService.get(((class_3218)level).method_8503()).ifPresent(service -> service.markMailboxAsPendingName((class_1657)player, level, pos));
            }
            Network.getPlay().sendToPlayer(() -> player, (Object)new MessageNameMailbox(pos));
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 class_25862;
        if (!level.method_8608() && !state.method_27852(newState.method_26204()) && (class_25862 = level.method_8321(pos)) instanceof MailboxBlockEntity) {
            MailboxBlockEntity mailbox = (MailboxBlockEntity)class_25862;
            Optional.ofNullable(mailbox.getMailbox()).ifPresent(Mailbox::remove);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 result) {
        class_2586 class_25862;
        if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof MailboxBlockEntity) {
            Mailbox mailbox;
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
            if (!DeliveryService.isDeliverableDimension(level)) {
                ((class_3222)player).method_43502((class_2561)Utils.translation("gui", "invalid_mailbox", new Object[0]), true);
                return class_1269.field_5812;
            }
            if (((Boolean)state.method_11654((class_2769)ENABLED)).booleanValue()) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(false)), 3);
            }
            if ((mailbox = blockEntity.getMailbox()) != null && !mailbox.hasOwner()) {
                mailbox.setOwner(player.method_5667());
            }
            player.method_17355((class_3908)blockEntity);
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ENABLED});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MailboxBlockEntity(pos, state);
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33713);
    }
}

